#!/usr/bin/python3
"""Upotreba ./validate3.py test/*.in*"""

import string


def check(lines):
    nl = []   # ispravno formatirane linije
    E = "\n"  # line ending

    n, m = map(int, lines[0].split())
    assert 1 <= n * m <= 10 ** 6, "n*m kriv"
    nl.append("{} {}{}".format(n, m, E));

    set_a = set()

    for i in range(1, n+1):
        ai = list(map(int, lines[i].strip().split()))
        assert len(ai) == m, "cudna duljina reda"

        for j in range(m):
            set_a.add(ai[j])
            assert 1 <= ai[j] <= n * m, "kriv broj u matrici"

        nl.append("{}{}".format(" ".join(list(map(str, ai))), E))
   
    assert len(set_a) == n * m, "nije permutacija"

    assert lines == nl, "Krivi format (%s vs %s)" % (lines, nl)
    assert lines[-1][-1] == "\n", "Zadnji red ne zavrsava sa \\n"
    return {'n': n, 'm': m}


# Ocekivani clusteri! Ovo vjerojatno zelis promijeniti!
expected_clusters = {'n=1,m<=20':3, 'n=2,m<=20':6, 'n=1,m<=10**6':3, 'n=2,m<=5*10**5':6, 'n*m<=10**6': 12}


def what_cluster(data):
    # na temelju povratne informacije iz check(lines)
    # zakljucuje za TP u kojoj je bodovnoj sekciji
    if (data["n"] == 1 and data["m"] <= 20):
        return 'n=1,m<=20'
    if (data["n"] == 2 and data["m"] <= 20):
        return 'n=2,m<=20'
    if (data["n"] == 1 and data["m"] <= 10 ** 6):
        return 'n=1,m<=10**6'
    if (data["n"] == 2 and data["m"] <= 5 * 10 ** 5):
        return 'n=2,m<=5*10**5'
    return 'n*m<=10**6'

################### Zadatak-specifican kod iznad ove linije #########################

import sys
import glob
import hashlib


def group_in_batches(files):
    # mnozenje.in.1a, mnozenje.in.1b sprema u isti batch

    files.sort()
    B = []
    for f in files:
        if f[-1].islower() and len(B) > 0 and f[:-1] == B[-1][-1][:-1]:
            B[-1].append(f)
        else:
            B.append([f])
    return B


if __name__ == "__main__":
    f = []
    for pattern in sys.argv[1:]:
        for filename in glob.glob(pattern):
            f.append(filename)

    bc = []
    for batch in group_in_batches(f):
        if 'dummy' not in batch[0]:
            bc.append([])
        for filename in batch:
            print("{}: ".format(filename), end="")
            try:
                lines = open(filename).readlines()
                summary = check(lines)
                c = what_cluster(summary)
                if 'dummy' not in batch[0]:
                    bc[-1].append(c)
            except Exception as e:
                print("Greska!", e)
                raise
            else:
                print("Sve ok! (cluster {}, summary = {})".format(c, summary))

    clusters = {}
    for b in bc:
        for c in b:
            assert c == b[0], "Ima razlicitih cluster-a unutar batcha"
        if not b[0] in clusters:
            clusters[b[0]] = 0
        clusters[b[0]] += 1

    assert clusters == expected_clusters, "Kriva raspodjela clustera ({} vs {})".format(clusters, expected_clusters)

    # Buda test - provjeri duplikate
    hashes = set(hashlib.sha1(open(x, 'rb').read()).hexdigest() for x in f)
    assert len(hashes) == len(f), "Ima duplikata!"
